import { AdminLoginDto } from '~modules/auth/models/login';
import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import r from '~db/repositories';
import { HandledError } from '~core/classes/handled-error';
import { IJwtPayload } from '~modules/auth/models/jwt-payload';
import { JwtService } from '@nestjs/jwt';
import { verify } from '../../../../config/password';
import dict from '~constants/dict';

const users = r.users;
export class AdminLoginCommand {
  constructor(public dto: AdminLoginDto) {}
}

@CommandHandler(AdminLoginCommand)
export class AdminLoginCommandHandler
  implements ICommandHandler<AdminLoginCommand>
{
  constructor(private jwt: JwtService) {}

  async execute(command: AdminLoginCommand): Promise<any> {
    const { userName, password } = command.dto;

    const user = await users
      .createQueryBuilder('user')
      .where('user.cellphone = :userName', { userName })
      .addSelect("user.password")
      .getOne();

    if (!user) throw new HandledError(dict.WRONG_USERNAME_OR_PASSWORD);

    if (user.isSystemUser) throw new HandledError(dict.USER_IS_NOT_ALLOWED);

    const correct = await verify(user.password, password);
    if (!correct) throw new HandledError(dict.WRONG_USERNAME_OR_PASSWORD);

    const payload: IJwtPayload = {
      id: user.id,
    };

    return {
      token: this.jwt.sign(payload),
      user,
    };
  }
}
