import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import r from '~db/repositories';
import Dict from '~constants/dict';
import { JwtService } from '@nestjs/jwt';
import { BadRequestException } from '@nestjs/common';
import { VerifyDto } from '~modules/auth/models/verfiy';
import { IJwtPayload } from '~modules/auth/models/jwt-payload';

const { users, messages } = r;

export class VerifyCommand {
  constructor(public dto: VerifyDto) {}
}

@CommandHandler(VerifyCommand)
export class VerifyHandler implements ICommandHandler<VerifyCommand> {
  constructor(private readonly jwt: JwtService) {}

  async execute(command: VerifyCommand): Promise<any> {
    const { cellphone, code } = command.dto;

    let user: any = await users.findOneBy({ cellphone });

    const message = await messages
      .createQueryBuilder('message')
      .leftJoinAndSelect('message.user', 'user')
      .where('user.cellphone = :cellphone', { cellphone })
      .orderBy({ 'message.createdAt': 'DESC' })
      .getOne();

    if (code !== message.code)
      throw new BadRequestException(Dict.CODE_IS_NOT_CORRECT);

    delete user.password;

    const payload: IJwtPayload = {
      id: user.id,
    };

    return {
      token: this.jwt.sign(payload),
      user,
    };
  }
}
