import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Query,
} from '@nestjs/common';
import { ApiOkResponse, ApiTags } from '@nestjs/swagger';
import { CommandBus, QueryBus } from '@nestjs/cqrs';
import {
  DeletePlaceCommand,
  GetPlacesListQuery,
  GetPlacesListRequest,
  UpsertPlaceCommand,
  UpsertPlaceRequest,
} from '~modules/place/handlers';
import {
  GetSinglePlaceQuery,
  GetSinglePlaceResponse,
} from '~modules/place/handlers/queries/GetSinglePlace';

@ApiTags('Places Admin')
@Controller('admin/place')
export class AdminPlaceController {
  constructor(
    private readonly command: CommandBus,
    private readonly queryBus: QueryBus
  ) {}

  @Get('')
  list(@Query() query: GetPlacesListRequest) {
    return this.queryBus.execute(new GetPlacesListQuery(query));
  }

  @Post('')
  upsert(@Body() data: UpsertPlaceRequest) {
    return this.command.execute(new UpsertPlaceCommand(data));
  }

  @Get(':id')
  @ApiOkResponse({
    type: GetSinglePlaceResponse,
  })
  single(@Param('id') id: string) {
    return this.queryBus.execute(new GetSinglePlaceQuery(id));
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.command.execute(new DeletePlaceCommand(id));
  }
}
