import { Module } from '@nestjs/common';
import { AdminPlaceController } from '~modules/place/admin-place.controller';
import { CqrsModule } from '@nestjs/cqrs';
import {
  DeletePlaceHandler,
  GetPlacesListHandler,
  UpsertPlaceHandler,
} from '~modules/place/handlers';
import { GetSinglePlaceHandler } from '~modules/place/handlers/queries/GetSinglePlace';
import { PlaceController } from '~modules/place/place.controller';

@Module({
  imports: [CqrsModule],
  controllers: [PlaceController, AdminPlaceController],
  providers: [
    GetPlacesListHandler,
    UpsertPlaceHandler,
    GetSinglePlaceHandler,
    DeletePlaceHandler,
  ],
})
export class PlaceModule {}
