import { Inject, Injectable } from '@nestjs/common';
import { AxiosService } from '~core/axios';

const NEW_ADDRESS: string = 'new_address';

@Injectable()
export class ProjectService {
  constructor(private readonly axios: AxiosService) {}

  async list() {
    const { result = [] }: any = await this.axios.oldServer.post(
      'new_address',
      {
        address: 418,
      }
    );

    return result.map((x: any) => ({
      ...x,
      thumbnail: `${x?.projectSiteLogo}/${x?.projectLogo}`,
      url: `/pr/${x.projectUrl}`,
    }));
  }

  async content(id: string | number) {
    const { result = [] }: any = await this.axios.oldServer.post(
      'new_address',
      {
        address: 334,
        id,
      }
    );

    return result[0];
  }

  async projectData(title: string) {
    const { result = [] }: any = await this.axios.oldServer.post(NEW_ADDRESS, {
      address: 1950,
      id: title,
    });

    const res = result.map((x: any) => ({
      ...x,
      thumbnail: `${x.projectSiteLogo}/${x.projectLogo2}`,
    }))[0];

    return res;
  }

  async salesCondition(id: any) {
    const { result = [] }: any = await this.axios.oldServer.post(NEW_ADDRESS, {
      address: 1949,
      project: id,
    });
    return result;
  }

  async sendConsultForm(data: any) {
    const { result = [] }: any = await this.axios.oldServer.post(NEW_ADDRESS, {
      address: 371,
      ...data,
    });

    return result;
  }

  async getProjectType(code: any) {
    const {
      result = [],
      projectTitle,
      category,
    }: any = await this.axios.oldServer.post(NEW_ADDRESS, {
      address: 1948,
      code,
    });

    console.log({ result });

    const res = {
      title: projectTitle,
      types: [] as any[],
    };
    result.forEach((item: any) => {
      const index = res.types.findIndex(
        (x: any) => category === item.tipAttachCate
      );

      if (index !== -1) {
        res.types[index].images.push(
          `${item.tipAttachSite}/${item.tipAttachName}`
        );
      } else {
        const title = this.categoryTypeTitle?.find(
          (x: any) => x.category === item.tipAttachCate
        )?.title;
        const newItem = {
          title: title,
          category: item.tipAttachCate,
          images: [`${item.tipAttachSite}/${item.tipAttachName}`],
        };

        res.types.push(newItem);
      }
    });

    console.log({ res });

    return res;
  }

  private categoryTypeTitle: any = [
    {
      category: '1',
      title: '3D نمای خارجی',
    },
    {
      category: '2',
      title: '3D نمای داخلی',
    },
    {
      category: '3',
      title: '',
    },
    {
      category: '6',
      title: 'پلان معماری',
    },
    {
      category: '4',
      title: 'سازه',
    },
    {
      category: '5',
      title: '',
    },
    {
      category: '7',
      title: 'سایت پلان',
    },
    {
      category: '8',
      title: 'جزییات فنی',
    },
    {
      category: '9',
      title: 'شیت معماری',
    },
  ];
}
