import { UnsupportedMediaTypeException } from '@nestjs/common';
import Dict from '~constants/dict';
import * as path from 'path';
import { diskStorage } from 'multer';

const ImageFileFilter = (req: any, file: any, callback: any) => {
  if (!file.originalname.match(/\.(jpg|jpeg|png|pdf|PNG|JPG|JPEG|PDF)$/)) {
    const err = new UnsupportedMediaTypeException(
      Dict.FILE_SHOULD_BE_IMAGE_ERROR_MESSAGE
    );

    return callback(err, false);
  }
  callback(null, true);
};


export const ImgUploadConfigMaker = (key: string) => {
  return ({
  storage: diskStorage({
    destination: `../uploads/${key}`,
    filename: (req, file, cb) => {
      const randomName = Array(20)
        .fill(null)
        .map(() => Math.round(Math.random() * 16).toString(16))
        .join('');
      cb(null, `${key}-${randomName}${path.extname(file.originalname)}`);
    },
  }),
  fileFilter: ImageFileFilter
})
}
