import {
  Controller,
  MaxFileSizeValidator,
  ParseFilePipe,
  Post,
  UploadedFile,
  UseGuards,
  UseInterceptors,
} from '@nestjs/common';
import {
  ApiBearerAuth,
  ApiBody,
  ApiConsumes,
  ApiOkResponse,
  ApiTags,
} from '@nestjs/swagger';
import { FileInterceptor } from '@nestjs/platform-express';
import { UploadResponse } from '~modules/upload/model/upload.resopnse';
import { JwtAuthGuard } from '~core/guards/jwt-guard';
import { ImgUploadConfigMaker } from './config/img-uplod.config';

@ApiTags('Upload')
@ApiBearerAuth('access-token')
@UseGuards(JwtAuthGuard)
@Controller('upload')
export class UploadController {
  constructor() {}

  @Post('melli')
  @UseInterceptors(FileInterceptor('file', ImgUploadConfigMaker("melli")))
  @ApiConsumes('multipart/form-data')
  @ApiBody({
    schema: {
      type: 'object',
      properties: {
        file: {
          type: 'string',
          format: 'binary',
        },
      },
    },
  })
  @ApiOkResponse({
    type: UploadResponse,
  })
  melli(
    @UploadedFile(
      new ParseFilePipe({
        validators: [
          new MaxFileSizeValidator({
            maxSize: 1000000,
            message: 'تصویر نباید بزرگتر از 1 مگ باشد',
          }),
        ],
      })
    )
    file: any
  ) {
    return {
      path: `/uploads/melli/${file.filename}`,
    };
  }

  @Post('license')
  @UseInterceptors(FileInterceptor('file', ImgUploadConfigMaker("license")))
  @ApiConsumes('multipart/form-data')
  @ApiBody({
    schema: {
      type: 'object',
      properties: {
        file: {
          type: 'string',
          format: 'binary',
        },
      },
    },
  })
  @ApiOkResponse({
    type: UploadResponse,
  })
  license(
    @UploadedFile(
      new ParseFilePipe({
        validators: [
          new MaxFileSizeValidator({
            maxSize: 1000000,
            message: 'تصویر نباید بزرگتر از 1 مگ باشد',
          }),
        ],
      })
    )
    file: any
  ) {
    return {
      path: `/uploads/license/${file.filename}`,
    };
  }

  @Post('advertise')
  @UseInterceptors(FileInterceptor('file', ImgUploadConfigMaker("advertise")))
  @ApiConsumes('multipart/form-data')
  @ApiBody({
    schema: {
      type: 'object',
      properties: {
        file: {
          type: 'string',
          format: 'binary',
        },
      },
    },
  })
  @ApiOkResponse({
    type: UploadResponse,
  })
  advertise(
    @UploadedFile(
      new ParseFilePipe({
        validators: [
          new MaxFileSizeValidator({
            maxSize: 1000000,
            message: 'تصویر نباید بزرگتر از 1 مگ باشد',
          }),
        ],
      })
    )
    file: any
  ) {
    return {
      path: `/uploads/advertise/${file.filename}`,
    };
  }
}
