import {
  Body,
  Controller,
  Delete,
  Get,
  Patch,
  Post,
  Query,
} from '@nestjs/common';
import { ApiOkResponse, ApiTags } from '@nestjs/swagger';
import { CommandBus, QueryBus } from '@nestjs/cqrs';
import {
  GetUserListDto,
  GetUserListQuery,
} from '~modules/users/handlers/queries/GetUserListQuery';
import { GetUserListResponse } from '~modules/users/models/GetUserListResponse';
import {
  UpsertSystemUserCommand,
  UpsertSystemUserRequestModel,
} from '~modules/users/handlers';

@ApiTags('User Admin')
@Controller('admin/user')
export class AdminUserController {
  constructor(
    private readonly command: CommandBus,
    private readonly query: QueryBus
  ) {}

  @Get()
  @ApiOkResponse({
    type: GetUserListResponse,
  })
  async users(@Query() query: GetUserListDto) {
    return this.query.execute(new GetUserListQuery(query));
  }

  @Get(':id')
  async user() {}

  @Post('system')
  async upsert(@Body() data: UpsertSystemUserRequestModel) {
    return await this.command.execute(new UpsertSystemUserCommand(data));
  }

  @Patch(':id')
  async changePassword() {}

  @Delete(':id')
  async delete() {}
}
