import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import { UserEntity } from '~db/entities/user.entity';

export class ToggleFirstLoginCommand {
  constructor(public user: UserEntity) {}
}

@CommandHandler(ToggleFirstLoginCommand)
export class ToggleFirstLoginHandler
  implements ICommandHandler<ToggleFirstLoginCommand>
{
  async execute(command: ToggleFirstLoginCommand): Promise<any> {
    const user = command.user;

    await user.save();

    return user;
  }
}
