import { IQueryHandler, QueryHandler } from '@nestjs/cqrs';
import { QueryModel } from '~model/query';
import r from '~db/repositories';
import { ApiProperty } from '@nestjs/swagger';

const { users } = r;

export class GetUserListDto extends QueryModel {
  @ApiProperty({
    required: false,
    enum: ['system', 'subscriber'],
    default: 'subscriber',
  })
  type?: 'system' | 'subscriber';
}
export class GetUserListQuery {
  constructor(public dto: GetUserListDto) {}
}

@QueryHandler(GetUserListQuery)
export class GetUserListHandler implements IQueryHandler<GetUserListQuery> {
  async execute(props: GetUserListQuery): Promise<any> {
    const { offset = 1, size = 10, type = 'subscriber' } = props.dto;

    const query = users
      .createQueryBuilder('user')
      .leftJoinAndSelect('agency.city', 'city')
      .leftJoinAndSelect('agency.areas', 'areas')
      .select(['user'])
      .where('user.type = :type', { type });

    let [list, total] = await Promise.all([
      query.paginate({ offset, size }).getMany(),
      query.getCount(),
    ]);

    list = list.map((x) => {
      delete x?.password;
      return x;
    });

    return {
      total,
      list,
    };
  }
}
